﻿using System;
using System.Windows;

// Listing 4-8. Metody wirtualne oraz zagadnienie ich kolejności
class Firefighter
{
    // W ramach procesu gaszenia pożaru ta metoda 
    // wywołuje dwie kolejne: TrainHoseOnFire oraz TurnOnHose 
    public virtual void ExtinguishFire()
    {
        Console.WriteLine("{0} gasi pożar!", Name);
        TrainHoseOnFire();
        TurnOnHose();
    }

    private void TurnOnHose()
    {
        Console.WriteLine("Pożar wygasa.");
    }

    private void TrainHoseOnFire()
    {
        Console.WriteLine("Rozwija wąż w kierunku ognia.");
    }

    public string Name { get; set; }

    public void Drive(Firetruck truckToDrive, Point coordinates)
    {
        if (truckToDrive.Driver != this)
        {
            // Nie można jechać wozem straży pożarnej, jeśli 
            // nie ma kto nim kierować,
            // jednak takie zakańczanie metody bez zgłaszania 
            // informacji o problemie jest BARDZO ZŁE.
            // Tym, czego nam potrzeba, jest jakiś strukturalny 
            // sposób przekazywania klientom używającym naszych klas
            // informacji o problemach, które w nich zaistniały.
            // Wrócimy do tego zagadnienia w rozdziale 6.
            return;
        }
        truckToDrive.Drive(coordinates);
    }
}